package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginAccessControlConfig(
    name: String,
    description: Optional[String] = Optional.Absent,
    signingProtocol: zio.aws.cloudfront.model.OriginAccessControlSigningProtocols,
    signingBehavior: zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors,
    originAccessControlOriginType: zio.aws.cloudfront.model.OriginAccessControlOriginTypes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig = {
    import OriginAccessControlConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .signingProtocol(signingProtocol.unwrap)
      .signingBehavior(signingBehavior.unwrap)
      .originAccessControlOriginType(originAccessControlOriginType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly =
    zio.aws.cloudfront.model.OriginAccessControlConfig.wrap(buildAwsValue())
}
object OriginAccessControlConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginAccessControlConfig =
      zio.aws.cloudfront.model.OriginAccessControlConfig(
        name,
        description.map(value => value),
        signingProtocol,
        signingBehavior,
        originAccessControlOriginType
      )
    def name: String
    def description: Optional[String]
    def signingProtocol
        : zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
    def signingBehavior
        : zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
    def originAccessControlOriginType
        : zio.aws.cloudfront.model.OriginAccessControlOriginTypes
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSigningProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
    ] = ZIO.succeed(signingProtocol)
    def getSigningBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
    ] = ZIO.succeed(signingBehavior)
    def getOriginAccessControlOriginType: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlOriginTypes
    ] = ZIO.succeed(originAccessControlOriginType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig
  ) extends zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly {
    override val name: String = impl.name(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val signingProtocol
        : zio.aws.cloudfront.model.OriginAccessControlSigningProtocols =
      zio.aws.cloudfront.model.OriginAccessControlSigningProtocols
        .wrap(impl.signingProtocol())
    override val signingBehavior
        : zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors =
      zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors
        .wrap(impl.signingBehavior())
    override val originAccessControlOriginType
        : zio.aws.cloudfront.model.OriginAccessControlOriginTypes =
      zio.aws.cloudfront.model.OriginAccessControlOriginTypes
        .wrap(impl.originAccessControlOriginType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlConfig
  ): zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly = new Wrapper(
    impl
  )
}
