package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.SensitiveStringType
import scala.jdk.CollectionConverters._
final case class OriginCustomHeader(
    headerName: String,
    headerValue: SensitiveStringType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader = {
    import OriginCustomHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader
      .builder()
      .headerName(headerName: java.lang.String)
      .headerValue(SensitiveStringType.unwrap(headerValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly =
    zio.aws.cloudfront.model.OriginCustomHeader.wrap(buildAwsValue())
}
object OriginCustomHeader {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginCustomHeader =
      zio.aws.cloudfront.model.OriginCustomHeader(headerName, headerValue)
    def headerName: String
    def headerValue: SensitiveStringType
    def getHeaderName: ZIO[Any, Nothing, String] = ZIO.succeed(headerName)
    def getHeaderValue: ZIO[Any, Nothing, SensitiveStringType] =
      ZIO.succeed(headerValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader
  ) extends zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly {
    override val headerName: String = impl.headerName(): String
    override val headerValue: SensitiveStringType =
      zio.aws.cloudfront.model.primitives
        .SensitiveStringType(impl.headerValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader
  ): zio.aws.cloudfront.model.OriginCustomHeader.ReadOnly = new Wrapper(impl)
}
