package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OriginGroup(
    id: String,
    failoverCriteria: zio.aws.cloudfront.model.OriginGroupFailoverCriteria,
    members: zio.aws.cloudfront.model.OriginGroupMembers
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroup = {
    import OriginGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroup
      .builder()
      .id(id: java.lang.String)
      .failoverCriteria(failoverCriteria.buildAwsValue())
      .members(members.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginGroup.ReadOnly =
    zio.aws.cloudfront.model.OriginGroup.wrap(buildAwsValue())
}
object OriginGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroup =
      zio.aws.cloudfront.model
        .OriginGroup(id, failoverCriteria.asEditable, members.asEditable)
    def id: String
    def failoverCriteria
        : zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly
    def members: zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getFailoverCriteria: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly
    ] = ZIO.succeed(failoverCriteria)
    def getMembers: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly
    ] = ZIO.succeed(members)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ) extends zio.aws.cloudfront.model.OriginGroup.ReadOnly {
    override val id: String = impl.id(): String
    override val failoverCriteria
        : zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly =
      zio.aws.cloudfront.model.OriginGroupFailoverCriteria
        .wrap(impl.failoverCriteria())
    override val members: zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly =
      zio.aws.cloudfront.model.OriginGroupMembers.wrap(impl.members())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ): zio.aws.cloudfront.model.OriginGroup.ReadOnly = new Wrapper(impl)
}
