package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OriginGroupFailoverCriteria(
    statusCodes: zio.aws.cloudfront.model.StatusCodes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria = {
    import OriginGroupFailoverCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria
      .builder()
      .statusCodes(statusCodes.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly =
    zio.aws.cloudfront.model.OriginGroupFailoverCriteria.wrap(buildAwsValue())
}
object OriginGroupFailoverCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroupFailoverCriteria =
      zio.aws.cloudfront.model
        .OriginGroupFailoverCriteria(statusCodes.asEditable)
    def statusCodes: zio.aws.cloudfront.model.StatusCodes.ReadOnly
    def getStatusCodes
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.StatusCodes.ReadOnly] =
      ZIO.succeed(statusCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria
  ) extends zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly {
    override val statusCodes: zio.aws.cloudfront.model.StatusCodes.ReadOnly =
      zio.aws.cloudfront.model.StatusCodes.wrap(impl.statusCodes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupFailoverCriteria
  ): zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly =
    new Wrapper(impl)
}
