package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OriginGroupMember(originId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroupMember = {
    import OriginGroupMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroupMember
      .builder()
      .originId(originId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginGroupMember.ReadOnly =
    zio.aws.cloudfront.model.OriginGroupMember.wrap(buildAwsValue())
}
object OriginGroupMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroupMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroupMember =
      zio.aws.cloudfront.model.OriginGroupMember(originId)
    def originId: String
    def getOriginId: ZIO[Any, Nothing, String] = ZIO.succeed(originId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupMember
  ) extends zio.aws.cloudfront.model.OriginGroupMember.ReadOnly {
    override val originId: String = impl.originId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupMember
  ): zio.aws.cloudfront.model.OriginGroupMember.ReadOnly = new Wrapper(impl)
}
