package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class OriginGroupMembers(
    quantity: Integer,
    items: Iterable[zio.aws.cloudfront.model.OriginGroupMember]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers = {
    import OriginGroupMembers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers
      .builder()
      .quantity(quantity: java.lang.Integer)
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly =
    zio.aws.cloudfront.model.OriginGroupMembers.wrap(buildAwsValue())
}
object OriginGroupMembers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroupMembers =
      zio.aws.cloudfront.model.OriginGroupMembers(
        quantity,
        items.map { item =>
          item.asEditable
        }
      )
    def quantity: Integer
    def items: List[zio.aws.cloudfront.model.OriginGroupMember.ReadOnly]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.cloudfront.model.OriginGroupMember.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers
  ) extends zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : List[zio.aws.cloudfront.model.OriginGroupMember.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.OriginGroupMember.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroupMembers
  ): zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly = new Wrapper(impl)
}
