package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class OriginSslProtocols(
    quantity: Integer,
    items: Iterable[zio.aws.cloudfront.model.SslProtocol]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols = {
    import OriginSslProtocols.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols
      .builder()
      .quantity(quantity: java.lang.Integer)
      .itemsWithStrings(items.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly =
    zio.aws.cloudfront.model.OriginSslProtocols.wrap(buildAwsValue())
}
object OriginSslProtocols {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginSslProtocols =
      zio.aws.cloudfront.model.OriginSslProtocols(quantity, items)
    def quantity: Integer
    def items: List[zio.aws.cloudfront.model.SslProtocol]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems
        : ZIO[Any, Nothing, List[zio.aws.cloudfront.model.SslProtocol]] =
      ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols
  ) extends zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: List[zio.aws.cloudfront.model.SslProtocol] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.cloudfront.model.SslProtocol.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols
  ): zio.aws.cloudfront.model.OriginSslProtocols.ReadOnly = new Wrapper(impl)
}
