package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParametersInCacheKeyAndForwardedToOrigin(
    enableAcceptEncodingGzip: Boolean,
    enableAcceptEncodingBrotli: Optional[Boolean] = Optional.Absent,
    headersConfig: zio.aws.cloudfront.model.CachePolicyHeadersConfig,
    cookiesConfig: zio.aws.cloudfront.model.CachePolicyCookiesConfig,
    queryStringsConfig: zio.aws.cloudfront.model.CachePolicyQueryStringsConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin = {
    import ParametersInCacheKeyAndForwardedToOrigin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
      .builder()
      .enableAcceptEncodingGzip(enableAcceptEncodingGzip: java.lang.Boolean)
      .optionallyWith(
        enableAcceptEncodingBrotli.map(value => value: java.lang.Boolean)
      )(_.enableAcceptEncodingBrotli)
      .headersConfig(headersConfig.buildAwsValue())
      .cookiesConfig(cookiesConfig.buildAwsValue())
      .queryStringsConfig(queryStringsConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly =
    zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
      .wrap(buildAwsValue())
}
object ParametersInCacheKeyAndForwardedToOrigin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin =
      zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin(
        enableAcceptEncodingGzip,
        enableAcceptEncodingBrotli.map(value => value),
        headersConfig.asEditable,
        cookiesConfig.asEditable,
        queryStringsConfig.asEditable
      )
    def enableAcceptEncodingGzip: Boolean
    def enableAcceptEncodingBrotli: Optional[Boolean]
    def headersConfig
        : zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly
    def cookiesConfig
        : zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly
    def queryStringsConfig
        : zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly
    def getEnableAcceptEncodingGzip: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(enableAcceptEncodingGzip)
    def getEnableAcceptEncodingBrotli: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableAcceptEncodingBrotli",
        enableAcceptEncodingBrotli
      )
    def getHeadersConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly
    ] = ZIO.succeed(headersConfig)
    def getCookiesConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly
    ] = ZIO.succeed(cookiesConfig)
    def getQueryStringsConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly
    ] = ZIO.succeed(queryStringsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
  ) extends zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly {
    override val enableAcceptEncodingGzip: Boolean =
      impl.enableAcceptEncodingGzip(): Boolean
    override val enableAcceptEncodingBrotli: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAcceptEncodingBrotli())
        .map(value => value: Boolean)
    override val headersConfig
        : zio.aws.cloudfront.model.CachePolicyHeadersConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyHeadersConfig
        .wrap(impl.headersConfig())
    override val cookiesConfig
        : zio.aws.cloudfront.model.CachePolicyCookiesConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyCookiesConfig
        .wrap(impl.cookiesConfig())
    override val queryStringsConfig
        : zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyQueryStringsConfig
        .wrap(impl.queryStringsConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin
  ): zio.aws.cloudfront.model.ParametersInCacheKeyAndForwardedToOrigin.ReadOnly =
    new Wrapper(impl)
}
