package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait PriceClass {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.PriceClass
}
object PriceClass {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.PriceClass
  ): zio.aws.cloudfront.model.PriceClass = value match {
    case software.amazon.awssdk.services.cloudfront.model.PriceClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_100 =>
      val r = PriceClass_100
      r
    case software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_200 =>
      val r = PriceClass_200
      r
    case software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_ALL =>
      val r = PriceClass_All
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.PriceClass {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.PriceClass =
      software.amazon.awssdk.services.cloudfront.model.PriceClass.UNKNOWN_TO_SDK_VERSION
  }
  case object PriceClass_100 extends zio.aws.cloudfront.model.PriceClass {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.PriceClass =
      software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_100
  }
  case object PriceClass_200 extends zio.aws.cloudfront.model.PriceClass {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.PriceClass =
      software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_200
  }
  case object PriceClass_All extends zio.aws.cloudfront.model.PriceClass {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.PriceClass =
      software.amazon.awssdk.services.cloudfront.model.PriceClass.PRICE_CLASS_ALL
  }
}
