package zio.aws.cloudfront.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.cloudfront.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PublicKeySummary(
    id: String,
    name: String,
    createdTime: Timestamp,
    encodedKey: String,
    comment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublicKeySummary = {
    import PublicKeySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublicKeySummary
      .builder()
      .id(id: java.lang.String)
      .name(name: java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .encodedKey(encodedKey: java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublicKeySummary.ReadOnly =
    zio.aws.cloudfront.model.PublicKeySummary.wrap(buildAwsValue())
}
object PublicKeySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublicKeySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublicKeySummary =
      zio.aws.cloudfront.model.PublicKeySummary(
        id,
        name,
        createdTime,
        encodedKey,
        comment.map(value => value)
      )
    def id: String
    def name: String
    def createdTime: Timestamp
    def encodedKey: String
    def comment: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getEncodedKey: ZIO[Any, Nothing, String] = ZIO.succeed(encodedKey)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeySummary
  ) extends zio.aws.cloudfront.model.PublicKeySummary.ReadOnly {
    override val id: String = impl.id(): String
    override val name: String = impl.name(): String
    override val createdTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createdTime())
    override val encodedKey: String = impl.encodedKey(): String
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeySummary
  ): zio.aws.cloudfront.model.PublicKeySummary.ReadOnly = new Wrapper(impl)
}
