package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class QueryArgProfile(queryArg: String, profileId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.QueryArgProfile = {
    import QueryArgProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfile
      .builder()
      .queryArg(queryArg: java.lang.String)
      .profileId(profileId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.QueryArgProfile.ReadOnly =
    zio.aws.cloudfront.model.QueryArgProfile.wrap(buildAwsValue())
}
object QueryArgProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.QueryArgProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.QueryArgProfile =
      zio.aws.cloudfront.model.QueryArgProfile(queryArg, profileId)
    def queryArg: String
    def profileId: String
    def getQueryArg: ZIO[Any, Nothing, String] = ZIO.succeed(queryArg)
    def getProfileId: ZIO[Any, Nothing, String] = ZIO.succeed(profileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfile
  ) extends zio.aws.cloudfront.model.QueryArgProfile.ReadOnly {
    override val queryArg: String = impl.queryArg(): String
    override val profileId: String = impl.profileId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.QueryArgProfile
  ): zio.aws.cloudfront.model.QueryArgProfile.ReadOnly = new Wrapper(impl)
}
