package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait RealtimeMetricsSubscriptionStatus {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus
}
object RealtimeMetricsSubscriptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus
  ): zio.aws.cloudfront.model.RealtimeMetricsSubscriptionStatus = value match {
    case software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.RealtimeMetricsSubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus =
      software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends zio.aws.cloudfront.model.RealtimeMetricsSubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus =
      software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.ENABLED
  }
  case object Disabled
      extends zio.aws.cloudfront.model.RealtimeMetricsSubscriptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus =
      software.amazon.awssdk.services.cloudfront.model.RealtimeMetricsSubscriptionStatus.DISABLED
  }
}
