package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicy(
    id: String,
    lastModifiedTime: Timestamp,
    responseHeadersPolicyConfig: zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicy = {
    import ResponseHeadersPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicy
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .responseHeadersPolicyConfig(responseHeadersPolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicy.wrap(buildAwsValue())
}
object ResponseHeadersPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ResponseHeadersPolicy =
      zio.aws.cloudfront.model.ResponseHeadersPolicy(
        id,
        lastModifiedTime,
        responseHeadersPolicyConfig.asEditable
      )
    def id: String
    def lastModifiedTime: Timestamp
    def responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getResponseHeadersPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly
    ] = ZIO.succeed(responseHeadersPolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicy
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val responseHeadersPolicyConfig
        : zio.aws.cloudfront.model.ResponseHeadersPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.ResponseHeadersPolicyConfig
        .wrap(impl.responseHeadersPolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicy
  ): zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly = new Wrapper(impl)
}
