package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ResponseHeadersPolicyAccessControlAllowOrigins(
    quantity: Integer,
    items: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins = {
    import ResponseHeadersPolicyAccessControlAllowOrigins.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
      .builder()
      .quantity(quantity: java.lang.Integer)
      .items(items.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly =
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
      .wrap(buildAwsValue())
}
object ResponseHeadersPolicyAccessControlAllowOrigins {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins =
      zio.aws.cloudfront.model
        .ResponseHeadersPolicyAccessControlAllowOrigins(quantity, items)
    def quantity: Integer
    def items: List[String]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, Nothing, List[String]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
  ) extends zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: List[String] = impl
      .items()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowOrigins.ReadOnly =
    new Wrapper(impl)
}
