package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ResponseHeadersPolicyType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType
}
object ResponseHeadersPolicyType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType
  ): zio.aws.cloudfront.model.ResponseHeadersPolicyType = value match {
    case software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.MANAGED =>
      val r = managed
      r
    case software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.CUSTOM =>
      val r = custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ResponseHeadersPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object managed
      extends zio.aws.cloudfront.model.ResponseHeadersPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.MANAGED
  }
  case object custom
      extends zio.aws.cloudfront.model.ResponseHeadersPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyType.CUSTOM
  }
}
