package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Origin(domainName: String, originAccessIdentity: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.S3Origin = {
    import S3Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.S3Origin
      .builder()
      .domainName(domainName: java.lang.String)
      .originAccessIdentity(originAccessIdentity: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.S3Origin.ReadOnly =
    zio.aws.cloudfront.model.S3Origin.wrap(buildAwsValue())
}
object S3Origin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.S3Origin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.S3Origin =
      zio.aws.cloudfront.model.S3Origin(domainName, originAccessIdentity)
    def domainName: String
    def originAccessIdentity: String
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getOriginAccessIdentity: ZIO[Any, Nothing, String] =
      ZIO.succeed(originAccessIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.S3Origin
  ) extends zio.aws.cloudfront.model.S3Origin.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val originAccessIdentity: String =
      impl.originAccessIdentity(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.S3Origin
  ): zio.aws.cloudfront.model.S3Origin.ReadOnly = new Wrapper(impl)
}
