package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait SslProtocol {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.SslProtocol
}
object SslProtocol {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.SslProtocol
  ): zio.aws.cloudfront.model.SslProtocol = value match {
    case software.amazon.awssdk.services.cloudfront.model.SslProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.SslProtocol.SSL_V3 =>
      val r = SSLv3
      r
    case software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1 =>
      val r = TLSv1
      r
    case software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1_1 =>
      val r = `TLSv1.1`
      r
    case software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1_2 =>
      val r = `TLSv1.2`
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.SslProtocol {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SslProtocol =
      software.amazon.awssdk.services.cloudfront.model.SslProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object SSLv3 extends zio.aws.cloudfront.model.SslProtocol {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SslProtocol =
      software.amazon.awssdk.services.cloudfront.model.SslProtocol.SSL_V3
  }
  case object TLSv1 extends zio.aws.cloudfront.model.SslProtocol {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SslProtocol =
      software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1
  }
  case object `TLSv1.1` extends zio.aws.cloudfront.model.SslProtocol {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SslProtocol =
      software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1_1
  }
  case object `TLSv1.2` extends zio.aws.cloudfront.model.SslProtocol {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.SslProtocol =
      software.amazon.awssdk.services.cloudfront.model.SslProtocol.TLS_V1_2
  }
}
