package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StreamingLoggingConfig(
    enabled: Boolean,
    bucket: String,
    prefix: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig = {
    import StreamingLoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .bucket(bucket: java.lang.String)
      .prefix(prefix: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly =
    zio.aws.cloudfront.model.StreamingLoggingConfig.wrap(buildAwsValue())
}
object StreamingLoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.StreamingLoggingConfig =
      zio.aws.cloudfront.model.StreamingLoggingConfig(enabled, bucket, prefix)
    def enabled: Boolean
    def bucket: String
    def prefix: String
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getPrefix: ZIO[Any, Nothing, String] = ZIO.succeed(prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig
  ) extends zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val bucket: String = impl.bucket(): String
    override val prefix: String = impl.prefix(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.StreamingLoggingConfig
  ): zio.aws.cloudfront.model.StreamingLoggingConfig.ReadOnly = new Wrapper(
    impl
  )
}
