package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficConfig(
    singleWeightConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig
    ] = Optional.Absent,
    singleHeaderConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
    ] = Optional.Absent,
    `type`: zio.aws.cloudfront.model.ContinuousDeploymentPolicyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TrafficConfig = {
    import TrafficConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TrafficConfig
      .builder()
      .optionallyWith(singleWeightConfig.map(value => value.buildAwsValue()))(
        _.singleWeightConfig
      )
      .optionallyWith(singleHeaderConfig.map(value => value.buildAwsValue()))(
        _.singleHeaderConfig
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TrafficConfig.ReadOnly =
    zio.aws.cloudfront.model.TrafficConfig.wrap(buildAwsValue())
}
object TrafficConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TrafficConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TrafficConfig =
      zio.aws.cloudfront.model.TrafficConfig(
        singleWeightConfig.map(value => value.asEditable),
        singleHeaderConfig.map(value => value.asEditable),
        `type`
      )
    def singleWeightConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly
    ]
    def singleHeaderConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly
    ]
    def `type`: zio.aws.cloudfront.model.ContinuousDeploymentPolicyType
    def getSingleWeightConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly
    ] = AwsError.unwrapOptionField("singleWeightConfig", singleWeightConfig)
    def getSingleHeaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("singleHeaderConfig", singleHeaderConfig)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TrafficConfig
  ) extends zio.aws.cloudfront.model.TrafficConfig.ReadOnly {
    override val singleWeightConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singleWeightConfig())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentSingleWeightConfig
          .wrap(value)
      )
    override val singleHeaderConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.singleHeaderConfig())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
          .wrap(value)
      )
    override val `type`
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicyType =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TrafficConfig
  ): zio.aws.cloudfront.model.TrafficConfig.ReadOnly = new Wrapper(impl)
}
