package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrustedSigners(
    enabled: Boolean,
    quantity: Integer,
    items: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.TrustedSigners = {
    import TrustedSigners.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.TrustedSigners
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.TrustedSigners.ReadOnly =
    zio.aws.cloudfront.model.TrustedSigners.wrap(buildAwsValue())
}
object TrustedSigners {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.TrustedSigners
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.TrustedSigners =
      zio.aws.cloudfront.model
        .TrustedSigners(enabled, quantity, items.map(value => value))
    def enabled: Boolean
    def quantity: Integer
    def items: Optional[List[String]]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.TrustedSigners
  ) extends zio.aws.cloudfront.model.TrustedSigners.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.TrustedSigners
  ): zio.aws.cloudfront.model.TrustedSigners.ReadOnly = new Wrapper(impl)
}
