package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.ResourceARN
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resource: ResourceARN,
    tagKeys: zio.aws.cloudfront.model.TagKeys
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest
      .builder()
      .resource(ResourceARN.unwrap(resource): java.lang.String)
      .tagKeys(tagKeys.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UntagResourceRequest.ReadOnly =
    zio.aws.cloudfront.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UntagResourceRequest =
      zio.aws.cloudfront.model
        .UntagResourceRequest(resource, tagKeys.asEditable)
    def resource: ResourceARN
    def tagKeys: zio.aws.cloudfront.model.TagKeys.ReadOnly
    def getResource: ZIO[Any, Nothing, ResourceARN] = ZIO.succeed(resource)
    def getTagKeys
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.TagKeys.ReadOnly] =
      ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest
  ) extends zio.aws.cloudfront.model.UntagResourceRequest.ReadOnly {
    override val resource: ResourceARN =
      zio.aws.cloudfront.model.primitives.ResourceARN(impl.resource())
    override val tagKeys: zio.aws.cloudfront.model.TagKeys.ReadOnly =
      zio.aws.cloudfront.model.TagKeys.wrap(impl.tagKeys())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest
  ): zio.aws.cloudfront.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
