package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCloudFrontOriginAccessIdentityResponse(
    cloudFrontOriginAccessIdentity: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse = {
    import UpdateCloudFrontOriginAccessIdentityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
      .builder()
      .optionallyWith(
        cloudFrontOriginAccessIdentity.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentity)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
      .wrap(buildAwsValue())
}
object UpdateCloudFrontOriginAccessIdentityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse =
      zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse(
        cloudFrontOriginAccessIdentity.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def cloudFrontOriginAccessIdentity: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ]
    def eTag: Optional[String]
    def getCloudFrontOriginAccessIdentity: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentity",
      cloudFrontOriginAccessIdentity
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
  ) extends zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly {
    override val cloudFrontOriginAccessIdentity: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFrontOriginAccessIdentity())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse
  ): zio.aws.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse.ReadOnly =
    new Wrapper(impl)
}
