package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFieldLevelEncryptionProfileResponse(
    fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse = {
    import UpdateFieldLevelEncryptionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfile.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfile)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
      .wrap(buildAwsValue())
}
object UpdateFieldLevelEncryptionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse =
      zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse(
        fieldLevelEncryptionProfile.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ]
    def eTag: Optional[String]
    def getFieldLevelEncryptionProfile: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfile",
      fieldLevelEncryptionProfile
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
  ) extends zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly {
    override val fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLevelEncryptionProfile())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfile.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse
  ): zio.aws.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
