package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKeyGroupResponse(
    keyGroup: Optional[zio.aws.cloudfront.model.KeyGroup] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse = {
    import UpdateKeyGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse
      .builder()
      .optionallyWith(keyGroup.map(value => value.buildAwsValue()))(_.keyGroup)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateKeyGroupResponse.wrap(buildAwsValue())
}
object UpdateKeyGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateKeyGroupResponse =
      zio.aws.cloudfront.model.UpdateKeyGroupResponse(
        keyGroup.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def keyGroup: Optional[zio.aws.cloudfront.model.KeyGroup.ReadOnly]
    def eTag: Optional[String]
    def getKeyGroup
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyGroup.ReadOnly] =
      AwsError.unwrapOptionField("keyGroup", keyGroup)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse
  ) extends zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly {
    override val keyGroup
        : Optional[zio.aws.cloudfront.model.KeyGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyGroup())
        .map(value => zio.aws.cloudfront.model.KeyGroup.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse
  ): zio.aws.cloudfront.model.UpdateKeyGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
