package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateOriginAccessControlRequest(
    originAccessControlConfig: zio.aws.cloudfront.model.OriginAccessControlConfig,
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest = {
    import UpdateOriginAccessControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest
      .builder()
      .originAccessControlConfig(originAccessControlConfig.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateOriginAccessControlRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateOriginAccessControlRequest
      .wrap(buildAwsValue())
}
object UpdateOriginAccessControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateOriginAccessControlRequest =
      zio.aws.cloudfront.model.UpdateOriginAccessControlRequest(
        originAccessControlConfig.asEditable,
        id,
        ifMatch.map(value => value)
      )
    def originAccessControlConfig
        : zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    def id: String
    def ifMatch: Optional[String]
    def getOriginAccessControlConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = ZIO.succeed(originAccessControlConfig)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest
  ) extends zio.aws.cloudfront.model.UpdateOriginAccessControlRequest.ReadOnly {
    override val originAccessControlConfig
        : zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginAccessControlConfig
        .wrap(impl.originAccessControlConfig())
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest
  ): zio.aws.cloudfront.model.UpdateOriginAccessControlRequest.ReadOnly =
    new Wrapper(impl)
}
