package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateOriginAccessControlResponse(
    originAccessControl: Optional[
      zio.aws.cloudfront.model.OriginAccessControl
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse = {
    import UpdateOriginAccessControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse
      .builder()
      .optionallyWith(originAccessControl.map(value => value.buildAwsValue()))(
        _.originAccessControl
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateOriginAccessControlResponse
      .wrap(buildAwsValue())
}
object UpdateOriginAccessControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateOriginAccessControlResponse =
      zio.aws.cloudfront.model.UpdateOriginAccessControlResponse(
        originAccessControl.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly]
    def eTag: Optional[String]
    def getOriginAccessControl: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControl.ReadOnly
    ] = AwsError.unwrapOptionField("originAccessControl", originAccessControl)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse
  ) extends zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly {
    override val originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originAccessControl())
        .map(value => zio.aws.cloudfront.model.OriginAccessControl.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse
  ): zio.aws.cloudfront.model.UpdateOriginAccessControlResponse.ReadOnly =
    new Wrapper(impl)
}
