package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePublicKeyResponse(
    publicKey: Optional[zio.aws.cloudfront.model.PublicKey] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse = {
    import UpdatePublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse
      .builder()
      .optionallyWith(publicKey.map(value => value.buildAwsValue()))(
        _.publicKey
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdatePublicKeyResponse.wrap(buildAwsValue())
}
object UpdatePublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdatePublicKeyResponse =
      zio.aws.cloudfront.model.UpdatePublicKeyResponse(
        publicKey.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def publicKey: Optional[zio.aws.cloudfront.model.PublicKey.ReadOnly]
    def eTag: Optional[String]
    def getPublicKey
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.PublicKey.ReadOnly] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse
  ) extends zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly {
    override val publicKey
        : Optional[zio.aws.cloudfront.model.PublicKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicKey())
        .map(value => zio.aws.cloudfront.model.PublicKey.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse
  ): zio.aws.cloudfront.model.UpdatePublicKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
