package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRealtimeLogConfigRequest(
    endPoints: Optional[Iterable[zio.aws.cloudfront.model.EndPoint]] =
      Optional.Absent,
    fields: Optional[Iterable[String]] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    samplingRate: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest = {
    import UpdateRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
      .builder()
      .optionallyWith(
        endPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endPoints)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.fields)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(samplingRate.map(value => value: java.lang.Long))(
        _.samplingRate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest
      .wrap(buildAwsValue())
}
object UpdateRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest(
        endPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fields.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        samplingRate.map(value => value)
      )
    def endPoints: Optional[List[zio.aws.cloudfront.model.EndPoint.ReadOnly]]
    def fields: Optional[List[String]]
    def name: Optional[String]
    def arn: Optional[String]
    def samplingRate: Optional[Long]
    def getEndPoints
        : ZIO[Any, AwsError, List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] =
      AwsError.unwrapOptionField("endPoints", endPoints)
    def getFields: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("fields", fields)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getSamplingRate: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly {
    override val endPoints
        : Optional[List[zio.aws.cloudfront.model.EndPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.EndPoint.wrap(item)
          }.toList
        )
    override val fields: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val samplingRate: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.samplingRate())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.UpdateRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
