package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ViewerProtocolPolicy {
  def unwrap
      : software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy
}
object ViewerProtocolPolicy {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy
  ): zio.aws.cloudfront.model.ViewerProtocolPolicy = value match {
    case software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.ALLOW_ALL =>
      val r = `allow-all`
      r
    case software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.HTTPS_ONLY =>
      val r = `https-only`
      r
    case software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.REDIRECT_TO_HTTPS =>
      val r = `redirect-to-https`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ViewerProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `allow-all`
      extends zio.aws.cloudfront.model.ViewerProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.ALLOW_ALL
  }
  case object `https-only`
      extends zio.aws.cloudfront.model.ViewerProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.HTTPS_ONLY
  }
  case object `redirect-to-https`
      extends zio.aws.cloudfront.model.ViewerProtocolPolicy {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy =
      software.amazon.awssdk.services.cloudfront.model.ViewerProtocolPolicy.REDIRECT_TO_HTTPS
  }
}
