package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  Timestamp,
  Label,
  HapgArn,
  PartitionSerial,
  HsmArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHapgResponse(
    hapgArn: Option[HapgArn] = None,
    hapgSerial: Option[String] = None,
    hsmsLastActionFailed: Option[Iterable[HsmArn]] = None,
    hsmsPendingDeletion: Option[Iterable[HsmArn]] = None,
    hsmsPendingRegistration: Option[Iterable[HsmArn]] = None,
    label: Option[Label] = None,
    lastModifiedTimestamp: Option[Timestamp] = None,
    partitionSerialList: Option[Iterable[PartitionSerial]] = None,
    state: Option[zio.aws.cloudhsm.model.CloudHsmObjectState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse = {
    import DescribeHapgResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
      .builder()
      .optionallyWith(
        hapgArn.map(value => HapgArn.unwrap(value): java.lang.String)
      )(_.hapgArn)
      .optionallyWith(hapgSerial.map(value => value: java.lang.String))(
        _.hapgSerial
      )
      .optionallyWith(
        hsmsLastActionFailed.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsLastActionFailed)
      .optionallyWith(
        hsmsPendingDeletion.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsPendingDeletion)
      .optionallyWith(
        hsmsPendingRegistration.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmsPendingRegistration)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        partitionSerialList.map(value =>
          value.map { item =>
            PartitionSerial.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionSerialList)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHapgResponse.wrap(buildAwsValue())
}
object DescribeHapgResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHapgResponse =
      zio.aws.cloudhsm.model.DescribeHapgResponse(
        hapgArn.map(value => value),
        hapgSerial.map(value => value),
        hsmsLastActionFailed.map(value => value),
        hsmsPendingDeletion.map(value => value),
        hsmsPendingRegistration.map(value => value),
        label.map(value => value),
        lastModifiedTimestamp.map(value => value),
        partitionSerialList.map(value => value),
        state.map(value => value)
      )
    def hapgArn: Option[HapgArn]
    def hapgSerial: Option[String]
    def hsmsLastActionFailed: Option[List[HsmArn]]
    def hsmsPendingDeletion: Option[List[HsmArn]]
    def hsmsPendingRegistration: Option[List[HsmArn]]
    def label: Option[Label]
    def lastModifiedTimestamp: Option[Timestamp]
    def partitionSerialList: Option[List[PartitionSerial]]
    def state: Option[zio.aws.cloudhsm.model.CloudHsmObjectState]
    def getHapgArn: ZIO[Any, AwsError, HapgArn] =
      AwsError.unwrapOptionField("hapgArn", hapgArn)
    def getHapgSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hapgSerial", hapgSerial)
    def getHsmsLastActionFailed: ZIO[Any, AwsError, List[HsmArn]] =
      AwsError.unwrapOptionField("hsmsLastActionFailed", hsmsLastActionFailed)
    def getHsmsPendingDeletion: ZIO[Any, AwsError, List[HsmArn]] =
      AwsError.unwrapOptionField("hsmsPendingDeletion", hsmsPendingDeletion)
    def getHsmsPendingRegistration: ZIO[Any, AwsError, List[HsmArn]] = AwsError
      .unwrapOptionField("hsmsPendingRegistration", hsmsPendingRegistration)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getPartitionSerialList: ZIO[Any, AwsError, List[PartitionSerial]] =
      AwsError.unwrapOptionField("partitionSerialList", partitionSerialList)
    def getState
        : ZIO[Any, AwsError, zio.aws.cloudhsm.model.CloudHsmObjectState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ) extends zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly {
    override val hapgArn: Option[HapgArn] = scala
      .Option(impl.hapgArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HapgArn(value))
    override val hapgSerial: Option[String] =
      scala.Option(impl.hapgSerial()).map(value => value: String)
    override val hsmsLastActionFailed: Option[List[HsmArn]] = scala
      .Option(impl.hsmsLastActionFailed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.HsmArn(item)
        }.toList
      )
    override val hsmsPendingDeletion: Option[List[HsmArn]] = scala
      .Option(impl.hsmsPendingDeletion())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.HsmArn(item)
        }.toList
      )
    override val hsmsPendingRegistration: Option[List[HsmArn]] = scala
      .Option(impl.hsmsPendingRegistration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.HsmArn(item)
        }.toList
      )
    override val label: Option[Label] = scala
      .Option(impl.label())
      .map(value => zio.aws.cloudhsm.model.primitives.Label(value))
    override val lastModifiedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimestamp())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val partitionSerialList: Option[List[PartitionSerial]] = scala
      .Option(impl.partitionSerialList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.PartitionSerial(item)
        }.toList
      )
    override val state: Option[zio.aws.cloudhsm.model.CloudHsmObjectState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.cloudhsm.model.CloudHsmObjectState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse
  ): zio.aws.cloudhsm.model.DescribeHapgResponse.ReadOnly = new Wrapper(impl)
}
