package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  SubnetId,
  VpcId,
  IamRoleArn,
  Timestamp,
  SshKey,
  IpAddress,
  HsmArn,
  AZ,
  PartitionArn,
  EniId,
  HsmSerialNumber
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmResponse(
    hsmArn: Option[HsmArn] = None,
    status: Option[zio.aws.cloudhsm.model.HsmStatus] = None,
    statusDetails: Option[String] = None,
    availabilityZone: Option[AZ] = None,
    eniId: Option[EniId] = None,
    eniIp: Option[IpAddress] = None,
    subscriptionType: Option[zio.aws.cloudhsm.model.SubscriptionType] = None,
    subscriptionStartDate: Option[Timestamp] = None,
    subscriptionEndDate: Option[Timestamp] = None,
    vpcId: Option[VpcId] = None,
    subnetId: Option[SubnetId] = None,
    iamRoleArn: Option[IamRoleArn] = None,
    serialNumber: Option[HsmSerialNumber] = None,
    vendorName: Option[String] = None,
    hsmType: Option[String] = None,
    softwareVersion: Option[String] = None,
    sshPublicKey: Option[SshKey] = None,
    sshKeyLastUpdated: Option[Timestamp] = None,
    serverCertUri: Option[String] = None,
    serverCertLastUpdated: Option[Timestamp] = None,
    partitions: Option[Iterable[PartitionArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse = {
    import DescribeHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusDetails.map(value => value: java.lang.String))(
        _.statusDetails
      )
      .optionallyWith(
        availabilityZone.map(value => AZ.unwrap(value): java.lang.String)
      )(_.availabilityZone)
      .optionallyWith(
        eniId.map(value => EniId.unwrap(value): java.lang.String)
      )(_.eniId)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .optionallyWith(subscriptionType.map(value => value.unwrap))(
        _.subscriptionType
      )
      .optionallyWith(
        subscriptionStartDate.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.subscriptionStartDate)
      .optionallyWith(
        subscriptionEndDate.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.subscriptionEndDate)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        serialNumber.map(value =>
          HsmSerialNumber.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(vendorName.map(value => value: java.lang.String))(
        _.vendorName
      )
      .optionallyWith(hsmType.map(value => value: java.lang.String))(_.hsmType)
      .optionallyWith(softwareVersion.map(value => value: java.lang.String))(
        _.softwareVersion
      )
      .optionallyWith(
        sshPublicKey.map(value => SshKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .optionallyWith(
        sshKeyLastUpdated.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.sshKeyLastUpdated)
      .optionallyWith(serverCertUri.map(value => value: java.lang.String))(
        _.serverCertUri
      )
      .optionallyWith(
        serverCertLastUpdated.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.serverCertLastUpdated)
      .optionallyWith(
        partitions.map(value =>
          value.map { item =>
            PartitionArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitions)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHsmResponse.wrap(buildAwsValue())
}
object DescribeHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHsmResponse =
      zio.aws.cloudhsm.model.DescribeHsmResponse(
        hsmArn.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        availabilityZone.map(value => value),
        eniId.map(value => value),
        eniIp.map(value => value),
        subscriptionType.map(value => value),
        subscriptionStartDate.map(value => value),
        subscriptionEndDate.map(value => value),
        vpcId.map(value => value),
        subnetId.map(value => value),
        iamRoleArn.map(value => value),
        serialNumber.map(value => value),
        vendorName.map(value => value),
        hsmType.map(value => value),
        softwareVersion.map(value => value),
        sshPublicKey.map(value => value),
        sshKeyLastUpdated.map(value => value),
        serverCertUri.map(value => value),
        serverCertLastUpdated.map(value => value),
        partitions.map(value => value)
      )
    def hsmArn: Option[HsmArn]
    def status: Option[zio.aws.cloudhsm.model.HsmStatus]
    def statusDetails: Option[String]
    def availabilityZone: Option[AZ]
    def eniId: Option[EniId]
    def eniIp: Option[IpAddress]
    def subscriptionType: Option[zio.aws.cloudhsm.model.SubscriptionType]
    def subscriptionStartDate: Option[Timestamp]
    def subscriptionEndDate: Option[Timestamp]
    def vpcId: Option[VpcId]
    def subnetId: Option[SubnetId]
    def iamRoleArn: Option[IamRoleArn]
    def serialNumber: Option[HsmSerialNumber]
    def vendorName: Option[String]
    def hsmType: Option[String]
    def softwareVersion: Option[String]
    def sshPublicKey: Option[SshKey]
    def sshKeyLastUpdated: Option[Timestamp]
    def serverCertUri: Option[String]
    def serverCertLastUpdated: Option[Timestamp]
    def partitions: Option[List[PartitionArn]]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.cloudhsm.model.HsmStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getAvailabilityZone: ZIO[Any, AwsError, AZ] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getEniId: ZIO[Any, AwsError, EniId] =
      AwsError.unwrapOptionField("eniId", eniId)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
    def getSubscriptionType
        : ZIO[Any, AwsError, zio.aws.cloudhsm.model.SubscriptionType] =
      AwsError.unwrapOptionField("subscriptionType", subscriptionType)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getSubscriptionEndDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionEndDate", subscriptionEndDate)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getSerialNumber: ZIO[Any, AwsError, HsmSerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getVendorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendorName", vendorName)
    def getHsmType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmType", hsmType)
    def getSoftwareVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
    def getSshPublicKey: ZIO[Any, AwsError, SshKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getSshKeyLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("sshKeyLastUpdated", sshKeyLastUpdated)
    def getServerCertUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertUri", serverCertUri)
    def getServerCertLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serverCertLastUpdated", serverCertLastUpdated)
    def getPartitions: ZIO[Any, AwsError, List[PartitionArn]] =
      AwsError.unwrapOptionField("partitions", partitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ) extends zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly {
    override val hsmArn: Option[HsmArn] = scala
      .Option(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
    override val status: Option[zio.aws.cloudhsm.model.HsmStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.cloudhsm.model.HsmStatus.wrap(value))
    override val statusDetails: Option[String] =
      scala.Option(impl.statusDetails()).map(value => value: String)
    override val availabilityZone: Option[AZ] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.cloudhsm.model.primitives.AZ(value))
    override val eniId: Option[EniId] = scala
      .Option(impl.eniId())
      .map(value => zio.aws.cloudhsm.model.primitives.EniId(value))
    override val eniIp: Option[IpAddress] = scala
      .Option(impl.eniIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
    override val subscriptionType
        : Option[zio.aws.cloudhsm.model.SubscriptionType] = scala
      .Option(impl.subscriptionType())
      .map(value => zio.aws.cloudhsm.model.SubscriptionType.wrap(value))
    override val subscriptionStartDate: Option[Timestamp] = scala
      .Option(impl.subscriptionStartDate())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val subscriptionEndDate: Option[Timestamp] = scala
      .Option(impl.subscriptionEndDate())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.cloudhsm.model.primitives.VpcId(value))
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.cloudhsm.model.primitives.SubnetId(value))
    override val iamRoleArn: Option[IamRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.cloudhsm.model.primitives.IamRoleArn(value))
    override val serialNumber: Option[HsmSerialNumber] = scala
      .Option(impl.serialNumber())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmSerialNumber(value))
    override val vendorName: Option[String] =
      scala.Option(impl.vendorName()).map(value => value: String)
    override val hsmType: Option[String] =
      scala.Option(impl.hsmType()).map(value => value: String)
    override val softwareVersion: Option[String] =
      scala.Option(impl.softwareVersion()).map(value => value: String)
    override val sshPublicKey: Option[SshKey] = scala
      .Option(impl.sshPublicKey())
      .map(value => zio.aws.cloudhsm.model.primitives.SshKey(value))
    override val sshKeyLastUpdated: Option[Timestamp] = scala
      .Option(impl.sshKeyLastUpdated())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val serverCertUri: Option[String] =
      scala.Option(impl.serverCertUri()).map(value => value: String)
    override val serverCertLastUpdated: Option[Timestamp] = scala
      .Option(impl.serverCertLastUpdated())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val partitions: Option[List[PartitionArn]] = scala
      .Option(impl.partitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.PartitionArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse
  ): zio.aws.cloudhsm.model.DescribeHsmResponse.ReadOnly = new Wrapper(impl)
}
