package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  Certificate,
  Timestamp,
  Label,
  ClientArn,
  CertificateFingerprint
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLunaClientResponse(
    clientArn: Option[ClientArn] = None,
    certificate: Option[Certificate] = None,
    certificateFingerprint: Option[CertificateFingerprint] = None,
    lastModifiedTimestamp: Option[Timestamp] = None,
    label: Option[Label] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse = {
    import DescribeLunaClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse
      .builder()
      .optionallyWith(
        clientArn.map(value => ClientArn.unwrap(value): java.lang.String)
      )(_.clientArn)
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(
        certificateFingerprint.map(value =>
          CertificateFingerprint.unwrap(value): java.lang.String
        )
      )(_.certificateFingerprint)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          Timestamp.unwrap(value): java.lang.String
        )
      )(_.lastModifiedTimestamp)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly =
    zio.aws.cloudhsm.model.DescribeLunaClientResponse.wrap(buildAwsValue())
}
object DescribeLunaClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeLunaClientResponse =
      zio.aws.cloudhsm.model.DescribeLunaClientResponse(
        clientArn.map(value => value),
        certificate.map(value => value),
        certificateFingerprint.map(value => value),
        lastModifiedTimestamp.map(value => value),
        label.map(value => value)
      )
    def clientArn: Option[ClientArn]
    def certificate: Option[Certificate]
    def certificateFingerprint: Option[CertificateFingerprint]
    def lastModifiedTimestamp: Option[Timestamp]
    def label: Option[Label]
    def getClientArn: ZIO[Any, AwsError, ClientArn] =
      AwsError.unwrapOptionField("clientArn", clientArn)
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateFingerprint: ZIO[Any, AwsError, CertificateFingerprint] =
      AwsError.unwrapOptionField(
        "certificateFingerprint",
        certificateFingerprint
      )
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse
  ) extends zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly {
    override val clientArn: Option[ClientArn] = scala
      .Option(impl.clientArn())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientArn(value))
    override val certificate: Option[Certificate] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.cloudhsm.model.primitives.Certificate(value))
    override val certificateFingerprint: Option[CertificateFingerprint] = scala
      .Option(impl.certificateFingerprint())
      .map(value =>
        zio.aws.cloudhsm.model.primitives.CertificateFingerprint(value)
      )
    override val lastModifiedTimestamp: Option[Timestamp] = scala
      .Option(impl.lastModifiedTimestamp())
      .map(value => zio.aws.cloudhsm.model.primitives.Timestamp(value))
    override val label: Option[Label] = scala
      .Option(impl.label())
      .map(value => zio.aws.cloudhsm.model.primitives.Label(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse
  ): zio.aws.cloudhsm.model.DescribeLunaClientResponse.ReadOnly = new Wrapper(
    impl
  )
}
