package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{HapgArn, ClientArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetConfigRequest(
    clientArn: ClientArn,
    clientVersion: zio.aws.cloudhsm.model.ClientVersion,
    hapgList: Iterable[HapgArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest = {
    import GetConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest
      .builder()
      .clientArn(ClientArn.unwrap(clientArn): java.lang.String)
      .clientVersion(clientVersion.unwrap)
      .hapgList(hapgList.map { item =>
        HapgArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.GetConfigRequest.ReadOnly =
    zio.aws.cloudhsm.model.GetConfigRequest.wrap(buildAwsValue())
}
object GetConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.GetConfigRequest =
      zio.aws.cloudhsm.model
        .GetConfigRequest(clientArn, clientVersion, hapgList)
    def clientArn: ClientArn
    def clientVersion: zio.aws.cloudhsm.model.ClientVersion
    def hapgList: List[HapgArn]
    def getClientArn: ZIO[Any, Nothing, ClientArn] = ZIO.succeed(clientArn)
    def getClientVersion
        : ZIO[Any, Nothing, zio.aws.cloudhsm.model.ClientVersion] =
      ZIO.succeed(clientVersion)
    def getHapgList: ZIO[Any, Nothing, List[HapgArn]] = ZIO.succeed(hapgList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest
  ) extends zio.aws.cloudhsm.model.GetConfigRequest.ReadOnly {
    override val clientArn: ClientArn =
      zio.aws.cloudhsm.model.primitives.ClientArn(impl.clientArn())
    override val clientVersion: zio.aws.cloudhsm.model.ClientVersion =
      zio.aws.cloudhsm.model.ClientVersion.wrap(impl.clientVersion())
    override val hapgList: List[HapgArn] = impl
      .hapgList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.primitives.HapgArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest
  ): zio.aws.cloudhsm.model.GetConfigRequest.ReadOnly = new Wrapper(impl)
}
