package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetConfigResponse(
    configType: Option[String] = None,
    configFile: Option[String] = None,
    configCred: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse = {
    import GetConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
      .builder()
      .optionallyWith(configType.map(value => value: java.lang.String))(
        _.configType
      )
      .optionallyWith(configFile.map(value => value: java.lang.String))(
        _.configFile
      )
      .optionallyWith(configCred.map(value => value: java.lang.String))(
        _.configCred
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly =
    zio.aws.cloudhsm.model.GetConfigResponse.wrap(buildAwsValue())
}
object GetConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.GetConfigResponse =
      zio.aws.cloudhsm.model.GetConfigResponse(
        configType.map(value => value),
        configFile.map(value => value),
        configCred.map(value => value)
      )
    def configType: Option[String]
    def configFile: Option[String]
    def configCred: Option[String]
    def getConfigType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configType", configType)
    def getConfigFile: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configFile", configFile)
    def getConfigCred: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configCred", configCred)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ) extends zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly {
    override val configType: Option[String] =
      scala.Option(impl.configType()).map(value => value: String)
    override val configFile: Option[String] =
      scala.Option(impl.configFile()).map(value => value: String)
    override val configCred: Option[String] =
      scala.Option(impl.configCred()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse
  ): zio.aws.cloudhsm.model.GetConfigResponse.ReadOnly = new Wrapper(impl)
}
