package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{PaginationToken, HsmArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListHsmsResponse(
    hsmList: Option[Iterable[HsmArn]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse = {
    import ListHsmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse
      .builder()
      .optionallyWith(
        hsmList.map(value =>
          value.map { item =>
            HsmArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hsmList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListHsmsResponse.wrap(buildAwsValue())
}
object ListHsmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListHsmsResponse =
      zio.aws.cloudhsm.model.ListHsmsResponse(
        hsmList.map(value => value),
        nextToken.map(value => value)
      )
    def hsmList: Option[List[HsmArn]]
    def nextToken: Option[PaginationToken]
    def getHsmList: ZIO[Any, AwsError, List[HsmArn]] =
      AwsError.unwrapOptionField("hsmList", hsmList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse
  ) extends zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly {
    override val hsmList: Option[List[HsmArn]] = scala
      .Option(impl.hsmList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.HsmArn(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse
  ): zio.aws.cloudhsm.model.ListHsmsResponse.ReadOnly = new Wrapper(impl)
}
