package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{PartitionSerial, Label, HapgArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyHapgRequest(
    hapgArn: HapgArn,
    label: Option[Label] = None,
    partitionSerialList: Option[Iterable[PartitionSerial]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest = {
    import ModifyHapgRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest
      .builder()
      .hapgArn(HapgArn.unwrap(hapgArn): java.lang.String)
      .optionallyWith(
        label.map(value => Label.unwrap(value): java.lang.String)
      )(_.label)
      .optionallyWith(
        partitionSerialList.map(value =>
          value.map { item =>
            PartitionSerial.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionSerialList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyHapgRequest.ReadOnly =
    zio.aws.cloudhsm.model.ModifyHapgRequest.wrap(buildAwsValue())
}
object ModifyHapgRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyHapgRequest =
      zio.aws.cloudhsm.model.ModifyHapgRequest(
        hapgArn,
        label.map(value => value),
        partitionSerialList.map(value => value)
      )
    def hapgArn: HapgArn
    def label: Option[Label]
    def partitionSerialList: Option[List[PartitionSerial]]
    def getHapgArn: ZIO[Any, Nothing, HapgArn] = ZIO.succeed(hapgArn)
    def getLabel: ZIO[Any, AwsError, Label] =
      AwsError.unwrapOptionField("label", label)
    def getPartitionSerialList: ZIO[Any, AwsError, List[PartitionSerial]] =
      AwsError.unwrapOptionField("partitionSerialList", partitionSerialList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest
  ) extends zio.aws.cloudhsm.model.ModifyHapgRequest.ReadOnly {
    override val hapgArn: HapgArn =
      zio.aws.cloudhsm.model.primitives.HapgArn(impl.hapgArn())
    override val label: Option[Label] = scala
      .Option(impl.label())
      .map(value => zio.aws.cloudhsm.model.primitives.Label(value))
    override val partitionSerialList: Option[List[PartitionSerial]] = scala
      .Option(impl.partitionSerialList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.PartitionSerial(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest
  ): zio.aws.cloudhsm.model.ModifyHapgRequest.ReadOnly = new Wrapper(impl)
}
