package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{
  SubnetId,
  IamRoleArn,
  IpAddress,
  HsmArn,
  ExternalId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyHsmRequest(
    hsmArn: HsmArn,
    subnetId: Option[SubnetId] = None,
    eniIp: Option[IpAddress] = None,
    iamRoleArn: Option[IamRoleArn] = None,
    externalId: Option[ExternalId] = None,
    syslogIp: Option[IpAddress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest = {
    import ModifyHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest
      .builder()
      .hsmArn(HsmArn.unwrap(hsmArn): java.lang.String)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        eniIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.eniIp)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        syslogIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.syslogIp)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyHsmRequest.ReadOnly =
    zio.aws.cloudhsm.model.ModifyHsmRequest.wrap(buildAwsValue())
}
object ModifyHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyHsmRequest =
      zio.aws.cloudhsm.model.ModifyHsmRequest(
        hsmArn,
        subnetId.map(value => value),
        eniIp.map(value => value),
        iamRoleArn.map(value => value),
        externalId.map(value => value),
        syslogIp.map(value => value)
      )
    def hsmArn: HsmArn
    def subnetId: Option[SubnetId]
    def eniIp: Option[IpAddress]
    def iamRoleArn: Option[IamRoleArn]
    def externalId: Option[ExternalId]
    def syslogIp: Option[IpAddress]
    def getHsmArn: ZIO[Any, Nothing, HsmArn] = ZIO.succeed(hsmArn)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getEniIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("eniIp", eniIp)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getSyslogIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("syslogIp", syslogIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest
  ) extends zio.aws.cloudhsm.model.ModifyHsmRequest.ReadOnly {
    override val hsmArn: HsmArn =
      zio.aws.cloudhsm.model.primitives.HsmArn(impl.hsmArn())
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.cloudhsm.model.primitives.SubnetId(value))
    override val eniIp: Option[IpAddress] = scala
      .Option(impl.eniIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
    override val iamRoleArn: Option[IamRoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.cloudhsm.model.primitives.IamRoleArn(value))
    override val externalId: Option[ExternalId] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.cloudhsm.model.primitives.ExternalId(value))
    override val syslogIp: Option[IpAddress] = scala
      .Option(impl.syslogIp())
      .map(value => zio.aws.cloudhsm.model.primitives.IpAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest
  ): zio.aws.cloudhsm.model.ModifyHsmRequest.ReadOnly = new Wrapper(impl)
}
