package zio.aws.cloudhsm.model
import scala.jdk.CollectionConverters._
sealed trait SubscriptionType {
  def unwrap: software.amazon.awssdk.services.cloudhsm.model.SubscriptionType
}
object SubscriptionType {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsm.model.SubscriptionType
  ): zio.aws.cloudhsm.model.SubscriptionType = value match {
    case software.amazon.awssdk.services.cloudhsm.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsm.model.SubscriptionType.PRODUCTION =>
      val r = PRODUCTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudhsm.model.SubscriptionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.SubscriptionType =
      software.amazon.awssdk.services.cloudhsm.model.SubscriptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PRODUCTION extends zio.aws.cloudhsm.model.SubscriptionType {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.SubscriptionType =
      software.amazon.awssdk.services.cloudhsm.model.SubscriptionType.PRODUCTION
  }
}
