package zio.aws.cloudhsm.model
import scala.jdk.CollectionConverters._
sealed trait ClientVersion {
  def unwrap: software.amazon.awssdk.services.cloudhsm.model.ClientVersion
}
object ClientVersion {
  def wrap(
      value: software.amazon.awssdk.services.cloudhsm.model.ClientVersion
  ): zio.aws.cloudhsm.model.ClientVersion = value match {
    case software.amazon.awssdk.services.cloudhsm.model.ClientVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudhsm.model.ClientVersion.FIVE_ONE =>
      val r = FIVE_ONE
      r
    case software.amazon.awssdk.services.cloudhsm.model.ClientVersion.FIVE_THREE =>
      val r = FIVE_THREE
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudhsm.model.ClientVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.ClientVersion =
      software.amazon.awssdk.services.cloudhsm.model.ClientVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object FIVE_ONE extends zio.aws.cloudhsm.model.ClientVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.ClientVersion =
      software.amazon.awssdk.services.cloudhsm.model.ClientVersion.FIVE_ONE
  }
  case object FIVE_THREE extends zio.aws.cloudhsm.model.ClientVersion {
    override def unwrap
        : software.amazon.awssdk.services.cloudhsm.model.ClientVersion =
      software.amazon.awssdk.services.cloudhsm.model.ClientVersion.FIVE_THREE
  }
}
