package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.HsmArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateHsmResponse(hsmArn: Option[HsmArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse = {
    import CreateHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly =
    zio.aws.cloudhsm.model.CreateHsmResponse.wrap(buildAwsValue())
}
object CreateHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.CreateHsmResponse =
      zio.aws.cloudhsm.model.CreateHsmResponse(hsmArn.map(value => value))
    def hsmArn: Option[HsmArn]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse
  ) extends zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly {
    override val hsmArn: Option[HsmArn] = scala
      .Option(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse
  ): zio.aws.cloudhsm.model.CreateHsmResponse.ReadOnly = new Wrapper(impl)
}
