package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{Certificate, ClientLabel}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLunaClientRequest(
    label: Option[ClientLabel] = None,
    certificate: Certificate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest = {
    import CreateLunaClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest
      .builder()
      .optionallyWith(
        label.map(value => ClientLabel.unwrap(value): java.lang.String)
      )(_.label)
      .certificate(Certificate.unwrap(certificate): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.CreateLunaClientRequest.ReadOnly =
    zio.aws.cloudhsm.model.CreateLunaClientRequest.wrap(buildAwsValue())
}
object CreateLunaClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.CreateLunaClientRequest =
      zio.aws.cloudhsm.model
        .CreateLunaClientRequest(label.map(value => value), certificate)
    def label: Option[ClientLabel]
    def certificate: Certificate
    def getLabel: ZIO[Any, AwsError, ClientLabel] =
      AwsError.unwrapOptionField("label", label)
    def getCertificate: ZIO[Any, Nothing, Certificate] =
      ZIO.succeed(certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest
  ) extends zio.aws.cloudhsm.model.CreateLunaClientRequest.ReadOnly {
    override val label: Option[ClientLabel] = scala
      .Option(impl.label())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientLabel(value))
    override val certificate: Certificate =
      zio.aws.cloudhsm.model.primitives.Certificate(impl.certificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest
  ): zio.aws.cloudhsm.model.CreateLunaClientRequest.ReadOnly = new Wrapper(impl)
}
