package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.ClientArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLunaClientRequest(clientArn: ClientArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest = {
    import DeleteLunaClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest
      .builder()
      .clientArn(ClientArn.unwrap(clientArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DeleteLunaClientRequest.ReadOnly =
    zio.aws.cloudhsm.model.DeleteLunaClientRequest.wrap(buildAwsValue())
}
object DeleteLunaClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DeleteLunaClientRequest =
      zio.aws.cloudhsm.model.DeleteLunaClientRequest(clientArn)
    def clientArn: ClientArn
    def getClientArn: ZIO[Any, Nothing, ClientArn] = ZIO.succeed(clientArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest
  ) extends zio.aws.cloudhsm.model.DeleteLunaClientRequest.ReadOnly {
    override val clientArn: ClientArn =
      zio.aws.cloudhsm.model.primitives.ClientArn(impl.clientArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest
  ): zio.aws.cloudhsm.model.DeleteLunaClientRequest.ReadOnly = new Wrapper(impl)
}
