package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{HsmSerialNumber, HsmArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmRequest(
    hsmArn: Option[HsmArn] = None,
    hsmSerialNumber: Option[HsmSerialNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest = {
    import DescribeHsmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .optionallyWith(
        hsmSerialNumber.map(value =>
          HsmSerialNumber.unwrap(value): java.lang.String
        )
      )(_.hsmSerialNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly =
    zio.aws.cloudhsm.model.DescribeHsmRequest.wrap(buildAwsValue())
}
object DescribeHsmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.DescribeHsmRequest =
      zio.aws.cloudhsm.model.DescribeHsmRequest(
        hsmArn.map(value => value),
        hsmSerialNumber.map(value => value)
      )
    def hsmArn: Option[HsmArn]
    def hsmSerialNumber: Option[HsmSerialNumber]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
    def getHsmSerialNumber: ZIO[Any, AwsError, HsmSerialNumber] =
      AwsError.unwrapOptionField("hsmSerialNumber", hsmSerialNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ) extends zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly {
    override val hsmArn: Option[HsmArn] = scala
      .Option(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
    override val hsmSerialNumber: Option[HsmSerialNumber] = scala
      .Option(impl.hsmSerialNumber())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmSerialNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest
  ): zio.aws.cloudhsm.model.DescribeHsmRequest.ReadOnly = new Wrapper(impl)
}
