package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.AZ
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAvailableZonesResponse(
    azList: Option[Iterable[AZ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse = {
    import ListAvailableZonesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
      .builder()
      .optionallyWith(
        azList.map(value =>
          value.map { item =>
            AZ.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.azList)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListAvailableZonesResponse.wrap(buildAwsValue())
}
object ListAvailableZonesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListAvailableZonesResponse =
      zio.aws.cloudhsm.model
        .ListAvailableZonesResponse(azList.map(value => value))
    def azList: Option[List[AZ]]
    def getAzList: ZIO[Any, AwsError, List[AZ]] =
      AwsError.unwrapOptionField("azList", azList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ) extends zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly {
    override val azList: Option[List[AZ]] = scala
      .Option(impl.azList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudhsm.model.primitives.AZ(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse
  ): zio.aws.cloudhsm.model.ListAvailableZonesResponse.ReadOnly = new Wrapper(
    impl
  )
}
