package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.PaginationToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLunaClientsRequest(
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest = {
    import ListLunaClientsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListLunaClientsRequest.ReadOnly =
    zio.aws.cloudhsm.model.ListLunaClientsRequest.wrap(buildAwsValue())
}
object ListLunaClientsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListLunaClientsRequest =
      zio.aws.cloudhsm.model
        .ListLunaClientsRequest(nextToken.map(value => value))
    def nextToken: Option[PaginationToken]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest
  ) extends zio.aws.cloudhsm.model.ListLunaClientsRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest
  ): zio.aws.cloudhsm.model.ListLunaClientsRequest.ReadOnly = new Wrapper(impl)
}
