package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.{PaginationToken, ClientArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLunaClientsResponse(
    clientList: Iterable[ClientArn],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse = {
    import ListLunaClientsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse
      .builder()
      .clientList(clientList.map { item =>
        ClientArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListLunaClientsResponse.wrap(buildAwsValue())
}
object ListLunaClientsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListLunaClientsResponse =
      zio.aws.cloudhsm.model
        .ListLunaClientsResponse(clientList, nextToken.map(value => value))
    def clientList: List[ClientArn]
    def nextToken: Option[PaginationToken]
    def getClientList: ZIO[Any, Nothing, List[ClientArn]] =
      ZIO.succeed(clientList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse
  ) extends zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly {
    override val clientList: List[ClientArn] = impl
      .clientList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.primitives.ClientArn(item)
      }
      .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.cloudhsm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse
  ): zio.aws.cloudhsm.model.ListLunaClientsResponse.ReadOnly = new Wrapper(impl)
}
