package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.HapgArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyHapgResponse(hapgArn: Option[HapgArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse = {
    import ModifyHapgResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse
      .builder()
      .optionallyWith(
        hapgArn.map(value => HapgArn.unwrap(value): java.lang.String)
      )(_.hapgArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly =
    zio.aws.cloudhsm.model.ModifyHapgResponse.wrap(buildAwsValue())
}
object ModifyHapgResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyHapgResponse =
      zio.aws.cloudhsm.model.ModifyHapgResponse(hapgArn.map(value => value))
    def hapgArn: Option[HapgArn]
    def getHapgArn: ZIO[Any, AwsError, HapgArn] =
      AwsError.unwrapOptionField("hapgArn", hapgArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse
  ) extends zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly {
    override val hapgArn: Option[HapgArn] = scala
      .Option(impl.hapgArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HapgArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse
  ): zio.aws.cloudhsm.model.ModifyHapgResponse.ReadOnly = new Wrapper(impl)
}
