package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.ClientArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyLunaClientResponse(clientArn: Option[ClientArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse = {
    import ModifyLunaClientResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse
      .builder()
      .optionallyWith(
        clientArn.map(value => ClientArn.unwrap(value): java.lang.String)
      )(_.clientArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly =
    zio.aws.cloudhsm.model.ModifyLunaClientResponse.wrap(buildAwsValue())
}
object ModifyLunaClientResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyLunaClientResponse =
      zio.aws.cloudhsm.model
        .ModifyLunaClientResponse(clientArn.map(value => value))
    def clientArn: Option[ClientArn]
    def getClientArn: ZIO[Any, AwsError, ClientArn] =
      AwsError.unwrapOptionField("clientArn", clientArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse
  ) extends zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly {
    override val clientArn: Option[ClientArn] = scala
      .Option(impl.clientArn())
      .map(value => zio.aws.cloudhsm.model.primitives.ClientArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse
  ): zio.aws.cloudhsm.model.ModifyLunaClientResponse.ReadOnly = new Wrapper(
    impl
  )
}
