package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tagList: Iterable[zio.aws.cloudhsm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse
      .builder()
      .tagList(tagList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.cloudhsm.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ListTagsForResourceResponse =
      zio.aws.cloudhsm.model.ListTagsForResourceResponse(tagList.map { item =>
        item.asEditable
      })
    def tagList: List[zio.aws.cloudhsm.model.Tag.ReadOnly]
    def getTagList
        : ZIO[Any, Nothing, List[zio.aws.cloudhsm.model.Tag.ReadOnly]] =
      ZIO.succeed(tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse
  ) extends zio.aws.cloudhsm.model.ListTagsForResourceResponse.ReadOnly {
    override val tagList: List[zio.aws.cloudhsm.model.Tag.ReadOnly] = impl
      .tagList()
      .asScala
      .map { item =>
        zio.aws.cloudhsm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse
  ): zio.aws.cloudhsm.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
