package zio.aws.cloudhsm.model
import zio.ZIO
import zio.aws.cloudhsm.model.primitives.HsmArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyHsmResponse(hsmArn: Optional[HsmArn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse = {
    import ModifyHsmResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse
      .builder()
      .optionallyWith(
        hsmArn.map(value => HsmArn.unwrap(value): java.lang.String)
      )(_.hsmArn)
      .build()
  }
  def asReadOnly: zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly =
    zio.aws.cloudhsm.model.ModifyHsmResponse.wrap(buildAwsValue())
}
object ModifyHsmResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudhsm.model.ModifyHsmResponse =
      zio.aws.cloudhsm.model.ModifyHsmResponse(hsmArn.map(value => value))
    def hsmArn: Optional[HsmArn]
    def getHsmArn: ZIO[Any, AwsError, HsmArn] =
      AwsError.unwrapOptionField("hsmArn", hsmArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse
  ) extends zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly {
    override val hsmArn: Optional[HsmArn] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmArn())
      .map(value => zio.aws.cloudhsm.model.primitives.HsmArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse
  ): zio.aws.cloudhsm.model.ModifyHsmResponse.ReadOnly = new Wrapper(impl)
}
